# Genloss Avis - Plateforme de Gestion d'Avis Rémunérés

## 📋 Description

Plateforme web full-stack de gestion d'avis rémunérés permettant aux utilisateurs de réserver des tâches d'avis, soumettre leurs preuves et demander des retraits. Les administrateurs peuvent gérer les tâches, valider les soumissions et traiter les paiements.

## 🚀 Technologies

- **Backend**: FastAPI (Python)
- **Frontend**: React + Tailwind CSS
- **Base de données**: MongoDB
- **Authentification**: JWT
- **Upload**: Images (preuves)

## 🔑 Identifiants par défaut

### Administrateur
- **Email**: ephacks6@gmail.com
- **Mot de passe**: admin123

### Utilisateur test
- **Email**: test@example.com
- **Mot de passe**: test123

## 🛠️ Installation locale (Développement)

### Prérequis
- Python 3.11+
- Node.js 18+
- MongoDB

### Backend
```bash
cd backend
pip install -r requirements.txt
python seed_data.py  # Initialiser la base de données
uvicorn server:app --host 0.0.0.0 --port 8001
```

### Frontend
```bash
cd frontend
yarn install
yarn start
```

Le site sera accessible sur `http://localhost:3000`

## 🌐 Déploiement sur Namecheap cPanel (Hébergement partagé)

### Important
⚠️ **L'hébergement partagé cPanel standard ne supporte généralement PAS**:
- MongoDB (nécessite serveur dédié/VPS)
- Python FastAPI directement
- React en mode développement

### Options de déploiement recommandées

#### Option 1: VPS/Serveur Dédié (Recommandé)

Si vous avez un VPS avec accès SSH sur Namecheap:

1. **Installer les dépendances**
```bash
# Python et pip
sudo apt update
sudo apt install python3.11 python3-pip

# Node.js
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt install -y nodejs

# MongoDB
sudo apt install mongodb-org
```

2. **Uploader le code**
```bash
# Via Git
git clone <votre-repo>

# Ou via SCP
scp -r /chemin/local/app/* user@votreserveur.com:/var/www/genloss/
```

3. **Configurer l'environnement**
```bash
# Backend
cd /var/www/genloss/backend
pip install -r requirements.txt
python seed_data.py

# Frontend - Build production
cd /var/www/genloss/frontend
npm install
npm run build
```

4. **Configurer Nginx**
```nginx
server {
    listen 80;
    server_name genloss.com www.genloss.com;

    # Frontend (fichiers statiques React)
    location / {
        root /var/www/genloss/frontend/build;
        try_files $uri /index.html;
    }

    # Backend API
    location /api/ {
        proxy_pass http://localhost:8001;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_cache_bypass $http_upgrade;
    }

    # Uploads
    location /uploads/ {
        alias /var/www/genloss/backend/uploads/;
    }
}
```

5. **Lancer l'application**
```bash
# Backend avec PM2 (gestionnaire de processus)
npm install -g pm2
pm2 start "uvicorn server:app --host 0.0.0.0 --port 8001" --name genloss-api
pm2 save
pm2 startup
```

#### Option 2: Hébergement Cloud (Alternative simple)

Pour éviter les complications du déploiement sur cPanel, considérez:

- **Railway.app** (gratuit pour commencer)
- **Heroku**
- **DigitalOcean App Platform**
- **Vercel** (Frontend) + **Railway** (Backend)

#### Option 3: Conversion pour cPanel classique

Si vous devez absolument utiliser cPanel partagé:

1. **Remplacer MongoDB par MySQL/PostgreSQL**
2. **Remplacer FastAPI par PHP**
3. **Build React en statique**

(Cette option nécessite une réécriture majeure du code)

## 📁 Structure du projet

```
/app/
├── backend/
│   ├── server.py           # API FastAPI
│   ├── seed_data.py        # Script d'initialisation
│   ├── requirements.txt    # Dépendances Python
│   ├── .env               # Configuration
│   └── uploads/           # Images uploadées
├── frontend/
│   ├── src/
│   │   ├── App.js         # Application principale
│   │   └── pages/
│   │       ├── LoginPage.js
│   │       ├── Dashboard.js
│   │       └── AdminPanel.js
│   ├── package.json
│   └── .env
└── README.md
```

## 🔧 Variables d'environnement

### Backend (.env)
```
MONGO_URL=mongodb://localhost:27017
DB_NAME=genloss_reviews
CORS_ORIGINS=*
JWT_SECRET=genloss-secret-key-change-in-production-2025
```

### Frontend (.env)
```
REACT_APP_BACKEND_URL=http://votre-domaine.com
```

## 📝 Fonctionnalités principales

### Utilisateurs
- ✅ Inscription/Connexion avec email et pseudo Discord
- ✅ Voir les tâches disponibles
- ✅ Réserver une tâche (1 seule à la fois)
- ✅ Soumettre preuve (image + lien)
- ✅ Voir soldes (en attente, disponible, retiré)
- ✅ Configurer compte PayPal
- ✅ Demander des retraits
- ✅ Historique des critiques et paiements

### Administrateurs
- ✅ Créer des tâches (titre, description, lien, rémunération)
- ✅ Valider/Rejeter les soumissions
- ✅ Voir les preuves (images)
- ✅ Gérer les utilisateurs (créer, modifier, activer/désactiver)
- ✅ Créer des admins ou utilisateurs
- ✅ Gérer les demandes de retrait
- ✅ Marquer les paiements comme effectués

## 💳 Gestion des paiements PayPal

⚠️ **Important**: Les paiements PayPal sont gérés **manuellement** par l'administrateur.

1. L'utilisateur demande un retrait avec son compte PayPal
2. L'admin voit la demande dans le panel
3. L'admin effectue le paiement manuellement via PayPal
4. L'admin marque la demande comme "payée" dans le système

**Note**: Pour intégrer l'API PayPal automatique, vous devrez:
- Créer un compte PayPal Business
- Obtenir des clés API PayPal
- Intégrer PayPal Payouts API dans le backend

## 🆘 Support

Un problème? Contactez-nous: [https://discord.gg/yEarkSJhEB](https://discord.gg/yEarkSJhEB)

## 📜 Licence

Propriétaire - Tous droits réservés

---

# ESPAÑOL (Resumen)

## Instalación en cPanel compartido de Namecheap

**Importante**: El hosting compartido de cPanel típicamente NO soporta:
- MongoDB (requiere VPS/servidor dedicado)
- FastAPI (Python) directamente
- React en modo desarrollo

### Opciones recomendadas:

1. **VPS en Namecheap**: Alquilar un VPS donde puedas instalar MongoDB y Python
2. **Cloud hosting**: Railway.app, Heroku, DigitalOcean
3. **Reescribir para cPanel**: Convertir a PHP + MySQL (trabajo significativo)

### Para VPS/Servidor dedicado:
```bash
# Instalar dependencias
apt install python3 nodejs mongodb

# Subir código
scp -r app/* user@servidor.com:/var/www/

# Configurar y ejecutar
cd /var/www/backend
pip install -r requirements.txt
python seed_data.py
uvicorn server:app --host 0.0.0.0 --port 8001

cd /var/www/frontend
npm install && npm run build
# Configurar Nginx para servir frontend + proxy API
```

**Contacto soporte**: https://discord.gg/yEarkSJhEB
