# 🎉 GENLOSS AVIS - INSTALLATION RAPIDE

## 📦 Fichier ZIP: genloss-avis-complet.zip

## 🔐 IDENTIFIANTS ADMIN

**Email**: ephacks6@gmail.com  
**Mot de passe**: admin123

**⚠️ IMPORTANT**: Changez ce mot de passe après la première connexion!

---

## 🚀 INSTALLATION (3 OPTIONS)

### ⭐ Option 1: VPS Namecheap (Recommandé)

**Prérequis**: VPS Ubuntu avec accès SSH

```bash
# 1. Connexion SSH
ssh root@votre-ip-vps

# 2. Installation dépendances
apt update && apt upgrade -y
apt install -y python3.11 python3-pip nodejs npm mongodb-org nginx

# 3. Uploader et extraire
scp genloss-avis-complet.zip root@votre-ip:/var/www/
cd /var/www/
unzip genloss-avis-complet.zip -d genloss
cd genloss

# 4. Backend
cd backend
pip install -r requirements.txt
python seed_data.py
nohup uvicorn server:app --host 0.0.0.0 --port 8001 &

# 5. Frontend
cd ../frontend
npm install
npm run build

# 6. Configurer Nginx (voir DEPLOYMENT_GUIDE.md)
```

**📖 Guide complet**: Consultez `DEPLOYMENT_GUIDE.md`

---

### ⭐ Option 2: Railway.app (Plus Facile)

1. Créer compte sur https://railway.app
2. "New Project" → "Deploy from GitHub"
3. Pushez votre code sur GitHub
4. Connectez à Railway
5. Ajoutez MongoDB depuis le marketplace
6. Configurez les variables d'environnement
7. Déployez!

**Coût**: Gratuit (avec limites) ou $5/mois

---

### ❌ Option 3: cPanel Partagé (NON SUPPORTÉ)

L'hébergement cPanel partagé Namecheap **NE SUPPORTE PAS**:
- MongoDB (base de données NoSQL)
- Python/FastAPI
- Node.js en production

**Solution**: Louez un VPS ou utilisez Railway.app

---

## 📝 APRÈS L'INSTALLATION

1. **Testez la connexion admin**:
   - Allez sur https://votre-domaine.com
   - Connectez-vous avec ephacks6@gmail.com / admin123

2. **Changez le mot de passe**:
   - Panneau Admin → Utilisateurs → Modifier votre compte

3. **Créez vos tâches**:
   - Panneau Admin → Onglet "Tâches"
   - Cliquez "Créer une nouvelle tâche"

4. **Configurez PayPal**:
   - Les paiements sont **MANUELS**
   - Vous recevrez les demandes de retrait
   - Payez via PayPal manuellement
   - Marquez comme "payé" dans le panel

---

## 🌐 CONFIGURATION DNS

Dans Namecheap → Domain List → genloss.com → Advanced DNS:

```
Type    Host    Value           TTL
A       @       VOTRE-IP-VPS    Automatic
A       www     VOTRE-IP-VPS    Automatic
```

---

## 🔧 STRUCTURE DU PROJET

```
/app/
├── backend/              → API FastAPI (Python)
│   ├── server.py        → Code principal
│   ├── seed_data.py     → Initialisation DB
│   └── uploads/         → Images uploadées
├── frontend/            → Interface React
│   └── src/pages/       → Pages du site
├── README.md            → Documentation complète
└── DEPLOYMENT_GUIDE.md  → Guide déploiement détaillé
```

---

## 📱 FONCTIONNALITÉS

### Utilisateurs:
- ✅ Inscription/Connexion (email + pseudo Discord)
- ✅ Réserver des tâches d'avis
- ✅ Soumettre preuve (photo + lien)
- ✅ Voir soldes (en attente, disponible, retiré)
- ✅ Demander retraits PayPal

### Admin:
- ✅ Créer tâches d'avis
- ✅ Valider/Rejeter soumissions
- ✅ Gérer utilisateurs
- ✅ Créer admins
- ✅ Traiter retraits manuellement

---

## 🆘 BESOIN D'AIDE?

**Discord Support**: https://discord.gg/yEarkSJhEB

**Questions fréquentes**:

**Q: Puis-je installer sur cPanel partagé?**  
R: Non, il vous faut un VPS ou utiliser Railway.app

**Q: Comment fonctionnent les paiements PayPal?**  
R: C'est manuel - vous payez via votre PayPal puis marquez comme "payé"

**Q: Combien coûte l'hébergement?**  
R: VPS Namecheap: ~$7-15/mois | Railway.app: Gratuit ou $5/mois

**Q: Est-ce que MongoDB est inclus?**  
R: Sur VPS, vous l'installez. Sur Railway, c'est automatique.

---

## 🎯 CHECKLIST POST-INSTALLATION

- [ ] Site accessible sur votre domaine
- [ ] Connexion admin fonctionne
- [ ] Mot de passe admin changé
- [ ] 2-3 tâches créées pour tester
- [ ] Créé un compte utilisateur test
- [ ] Testé le flux complet (réservation → soumission → validation)
- [ ] Configuré votre compte PayPal pour recevoir les retraits

---

## 📊 UTILISATEUR TEST INCLUS

**Email**: test@example.com  
**Mot de passe**: test123  
**Rôle**: Utilisateur normal

Utilisez-le pour tester le parcours utilisateur!

---

## 🔒 SÉCURITÉ

⚠️ **CHANGEZ IMMÉDIATEMENT**:
- Mot de passe admin
- JWT_SECRET dans backend/.env
- Mot de passe MongoDB (si accessible de l'extérieur)

---

**Bonne chance avec votre plateforme Genloss Avis!** 🚀

Pour toute question: https://discord.gg/yEarkSJhEB
