# Guide de Déploiement Complet - Genloss Avis

## 🎯 Objectif

Ce guide vous explique comment déployer votre site **genloss.com** sur différents types d'hébergement.

## ⚠️ Information Importante sur cPanel

**L'hébergement partagé Namecheap cPanel standard NE SUPPORTE PAS cette application directement.**

Pourquoi?
- ❌ Pas de support MongoDB (base de données NoSQL)
- ❌ Pas de support Python/FastAPI natif
- ❌ Limitations des ressources pour Node.js

## ✅ Solutions Recommandées

### Solution 1: VPS Namecheap (Meilleure option)

#### Étape 1: Commander un VPS
1. Allez sur Namecheap.com
2. Produits → VPS Hosting
3. Choisissez un plan (minimum "Pulsar" recommandé)
4. Installez Ubuntu 22.04 LTS

#### Étape 2: Connexion SSH
```bash
ssh root@votre-ip-vps
```

#### Étape 3: Installation des dépendances
```bash
# Mise à jour du système
apt update && apt upgrade -y

# Installation Python 3.11
apt install -y python3.11 python3-pip python3.11-venv

# Installation Node.js 18
curl -fsSL https://deb.nodesource.com/setup_18.x | bash -
apt install -y nodejs

# Installation MongoDB
wget -qO - https://www.mongodb.org/static/pgp/server-6.0.asc | apt-key add -
echo "deb [ arch=amd64,arm64 ] https://repo.mongodb.org/apt/ubuntu jammy/mongodb-org/6.0 multiverse" | tee /etc/apt/sources.list.d/mongodb-org-6.0.list
apt update
apt install -y mongodb-org

# Démarrer MongoDB
systemctl start mongod
systemctl enable mongod

# Installation Nginx
apt install -y nginx

# Installation PM2 (gestionnaire de processus Node)
npm install -g pm2
```

#### Étape 4: Télécharger votre code

**Option A: Via Git (recommandé)**
```bash
cd /var/www/
git clone https://github.com/votre-repo/genloss.git
cd genloss
```

**Option B: Via FileZilla/SCP**
```bash
# Sur votre ordinateur local
scp -r /chemin/vers/app/* root@votre-ip-vps:/var/www/genloss/
```

#### Étape 5: Configuration Backend
```bash
cd /var/www/genloss/backend

# Créer environnement virtuel Python
python3.11 -m venv venv
source venv/bin/activate

# Installer dépendances
pip install -r requirements.txt

# Configurer .env
nano .env
```

Contenu du fichier `.env`:
```
MONGO_URL=mongodb://localhost:27017
DB_NAME=genloss_reviews
CORS_ORIGINS=https://genloss.com,https://www.genloss.com
JWT_SECRET=CHANGEZ-CETTE-CLE-SECURITE-PRODUCTION-2025
```

```bash
# Initialiser la base de données
python seed_data.py

# Démarrer le backend avec PM2
pm2 start "venv/bin/uvicorn server:app --host 0.0.0.0 --port 8001" --name genloss-api
pm2 save
pm2 startup
```

#### Étape 6: Configuration Frontend
```bash
cd /var/www/genloss/frontend

# Installer dépendances
npm install

# Configurer .env pour production
nano .env
```

Contenu du fichier `.env`:
```
REACT_APP_BACKEND_URL=https://genloss.com
```

```bash
# Build production
npm run build
```

#### Étape 7: Configuration Nginx
```bash
nano /etc/nginx/sites-available/genloss
```

Contenu:
```nginx
server {
    listen 80;
    server_name genloss.com www.genloss.com;

    # Frontend React
    location / {
        root /var/www/genloss/frontend/build;
        try_files $uri $uri/ /index.html;
    }

    # Backend API
    location /api/ {
        proxy_pass http://localhost:8001;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
        proxy_cache_bypass $http_upgrade;
    }

    # Images uploadées
    location /uploads/ {
        alias /var/www/genloss/backend/uploads/;
        expires 30d;
        add_header Cache-Control "public, immutable";
    }
}
```

```bash
# Activer le site
ln -s /etc/nginx/sites-available/genloss /etc/nginx/sites-enabled/
rm /etc/nginx/sites-enabled/default

# Tester et redémarrer Nginx
nginx -t
systemctl restart nginx
```

#### Étape 8: Configuration SSL (HTTPS)
```bash
# Installer Certbot
apt install -y certbot python3-certbot-nginx

# Obtenir certificat SSL
certbot --nginx -d genloss.com -d www.genloss.com

# Renouvellement automatique
systemctl enable certbot.timer
```

#### Étape 9: Configuration DNS Namecheap
1. Connectez-vous à Namecheap
2. Allez dans "Domain List" → genloss.com → "Manage"
3. Onglet "Advanced DNS"
4. Ajoutez les enregistrements:

```
Type    Host    Value           TTL
A       @       VOTRE-IP-VPS    Automatic
A       www     VOTRE-IP-VPS    Automatic
```

#### Étape 10: Vérification
```bash
# Vérifier que tout tourne
pm2 status
systemctl status mongod
systemctl status nginx

# Voir les logs si problème
pm2 logs genloss-api
tail -f /var/log/nginx/error.log
```

Visitez https://genloss.com - Votre site devrait fonctionner!

---

### Solution 2: Cloud Hosting (Alternative Facile)

Si vous ne voulez pas gérer un serveur, utilisez des services cloud:

#### Railway.app (Gratuit pour commencer)

1. **Créer compte**: https://railway.app
2. **Créer nouveau projet**: "New Project" → "Deploy from GitHub repo"
3. **Ajouter services**:
   - Backend: Python (FastAPI)
   - MongoDB: "Add Database" → MongoDB
   - Frontend: Build React et déployer statique

4. **Variables d'environnement Backend**:
```
MONGO_URL=${MONGODB_URL}
DB_NAME=genloss_reviews
CORS_ORIGINS=*
JWT_SECRET=votre-secret-key
```

5. **Build Frontend** avec variable:
```
REACT_APP_BACKEND_URL=https://votre-backend.railway.app
```

6. **Domaine personnalisé**: Settings → Domains → Add genloss.com

#### Heroku (Alternative)

1. Créer compte Heroku
2. Installer Heroku CLI
3. Créer 2 apps: `genloss-api` et `genloss-web`
4. Ajouter MongoDB Atlas (gratuit)
5. Déployer backend et frontend séparément

#### DigitalOcean App Platform

1. Créer compte DigitalOcean
2. "Create" → "Apps"
3. Connecter GitHub repo
4. Configurer composants (Backend + Frontend + MongoDB)
5. Déployer

---

### Solution 3: Conversion pour cPanel (Très Complexe)

⚠️ **Non recommandé** - Nécessite réécriture majeure:

1. Remplacer FastAPI (Python) → PHP
2. Remplacer MongoDB → MySQL/PostgreSQL
3. Réécrire toute la logique backend en PHP
4. Build React → fichiers statiques à uploader
5. Configuration .htaccess pour routing

**Temps estimé**: 40-60 heures de développement

---

## 📊 Comparaison des Solutions

| Solution | Coût/mois | Difficulté | Temps setup | Recommandé |
|----------|-----------|------------|-------------|------------|
| VPS Namecheap | ~$7-15 | Moyenne | 2-3h | ✅ OUI |
| Railway.app | $0-5 | Facile | 30min | ✅ OUI |
| Heroku | $0-7 | Facile | 1h | ✅ OUI |
| DigitalOcean | $5-12 | Facile | 1h | ✅ OUI |
| cPanel converti | Variable | Très difficile | 40-60h | ❌ NON |

---

## 🔐 Sécurité Post-Déploiement

1. **Changer JWT_SECRET** dans `.env` backend
2. **Changer mot de passe admin**: Connectez-vous et modifiez via le panel
3. **Configurer firewall**:
```bash
ufw allow 22    # SSH
ufw allow 80    # HTTP
ufw allow 443   # HTTPS
ufw enable
```

4. **Backups MongoDB**:
```bash
# Créer script backup
nano /root/backup-mongo.sh
```

Contenu:
```bash
#!/bin/bash
DATE=$(date +%Y%m%d_%H%M%S)
mongodump --db genloss_reviews --out /root/backups/mongo_$DATE
find /root/backups -name "mongo_*" -mtime +7 -delete
```

```bash
chmod +x /root/backup-mongo.sh
crontab -e
# Ajouter: 0 2 * * * /root/backup-mongo.sh
```

---

## 🆘 Dépannage

### Le site ne charge pas
```bash
# Vérifier services
pm2 status
systemctl status nginx
systemctl status mongod

# Voir logs
pm2 logs genloss-api
tail -f /var/log/nginx/error.log
```

### Erreur 502 Bad Gateway
```bash
# Backend probablement arrêté
pm2 restart genloss-api
```

### Erreur MongoDB connection
```bash
# Redémarrer MongoDB
systemctl restart mongod

# Vérifier status
systemctl status mongod
```

### Les images ne s'affichent pas
```bash
# Vérifier permissions
chmod -R 755 /var/www/genloss/backend/uploads
chown -R www-data:www-data /var/www/genloss/backend/uploads
```

---

## 📞 Support

Pour toute question ou problème:
- Discord: https://discord.gg/yEarkSJhEB
- Email: support@genloss.com (configurez votre email)

---

## 🎉 Félicitations!

Votre plateforme Genloss Avis est maintenant en ligne! 

N'oubliez pas de:
- ✅ Tester tous les flux (inscription, connexion, tâches, paiements)
- ✅ Configurer votre compte PayPal Business
- ✅ Créer vos vraies tâches
- ✅ Inviter vos premiers utilisateurs
